/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.dialog.DateChooserPanel;
import DE.siemens.ad.logo.model.hardware.Logo6;
import DE.siemens.ad.logo.util.CalendarListener;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.IPV4Utils;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class SetClockPanel
extends DataInputPanel
implements ActionListener {
    private static final long serialVersionUID = -8670042623368442543L;
    static final int SET_HIGH_ADR = 67;
    static final int READ_HIGH_ADR = 68;
    static final int VALUE_HIGH_ADR = 251;
    static final int LOW_ADR = 0;
    protected Calendar fCalendar = new GregorianCalendar();
    protected int[] fValues = new int[6];
    private BorderJPanel ivjDatePanelBorder = null;
    private BorderJPanel ivjTimePanelBorder = null;
    private BorderJPanel ivjSingleOrLanPanelBorder = null;
    private JButton ivjActualTimeBtn = null;
    private EditableNumericSpinner ivjDayField = null;
    private JLabel ivjDayLabel = null;
    private EditableNumericSpinner ivjHourField = null;
    private JLabel ivjHourLabel = null;
    private EditableNumericSpinner ivjMinuteField = null;
    private JLabel ivjMinuteLabel = null;
    private EditableNumericSpinner ivjMonthField = null;
    private JLabel ivjMonthLabel = null;
    private JButton ivjReadBtn = null;
    private JButton ivjWriteBtn = null;
    private EditableNumericSpinner ivjYearField = null;
    private JLabel ivjYearLabel = null;
    private JButton ivjCalendarBtn = null;
    private JRadioButton fSingleBMButton = null;
    private JRadioButton fLANButton = null;
    private transient boolean fYearFrom2K = false;
    private ReadTelegramThread receiverThread = null;
    private DatagramSocket fDatagramSocket;

    public SetClockPanel(DatagramSocket ds) {
        this.fDatagramSocket = ds;
        this.initialize();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getWriteBtn()) {
            this.actionPerformed_WriteButton();
        }
        if (e.getSource() == this.getActualTimeBtn()) {
            this.actionPerformed_TimeButton();
        }
        if (e.getSource() == this.getReadBtn()) {
            this.actionPerformed_ReadButton();
        }
        if (e.getSource() == this.getCalendarBtn()) {
            this.showCalendarDlg();
        }
        if (e.getSource() == this.getSingleBMRadioBtn()) {
            this.actionPerformed_SingleBMButton();
        }
        if (e.getSource() == this.getLANRadioBtn()) {
            this.actionPerformed_LANButton();
        }
    }

    public void actionPerformed_ReadButton() {
        if (!this.getSingleBMRadioBtn().isSelected()) {
            return;
        }
        this.readDate();
        this.fValues[2] = this.fValues[2] == 99 && !this.fYearFrom2K ? this.fValues[2] + 1900 : this.fValues[2] + 2000;
        int oldHours = this.fValues[4];
        this.fCalendar.set(this.fValues[2], this.fValues[1] - 1, this.fValues[0], this.fValues[4], this.fValues[3]);
        this.calendarToValues();
        if (oldHours != this.ivjHourField.getValue()) {
            this.ivjHourField.setValue(oldHours);
        }
    }

    public void actionPerformed_TimeButton() {
        this.fCalendar.setTime(new Date());
        this.calendarToValues();
    }

    public void actionPerformed_WriteButton() {
        int oldHours = this.ivjHourField.getValue();
        this.fCalendar.set(this.ivjYearField.getValue(), this.ivjMonthField.getValue() - 1, this.ivjDayField.getValue(), oldHours, this.ivjMinuteField.getValue());
        this.calendarToValues();
        if (oldHours != this.ivjHourField.getValue()) {
            this.ivjHourField.setValue(oldHours);
        }
        this.fValues[0] = this.ivjDayField.getValue();
        this.fValues[1] = this.ivjMonthField.getValue();
        this.fValues[2] = this.ivjYearField.getValue() % 100;
        this.fValues[3] = this.ivjMinuteField.getValue();
        this.fValues[4] = this.ivjHourField.getValue();
        this.fValues[5] = this.fCalendar.get(7) - 1;
        if (this.getSingleBMRadioBtn().isSelected()) {
            this.writeDate();
        } else {
            try {
                if (this.receiverThread == null || !this.receiverThread.isAlive()) {
                    this.receiverThread = new ReadTelegramThread();
                    this.receiverThread.start();
                } else {
                    this.receiverThread.refreshStartTime();
                }
                byte[] buf = new byte[]{1, 0, 67, -1, 0, (byte)this.fValues[0], (byte)this.fValues[1], (byte)this.fValues[2], (byte)this.fValues[3], (byte)this.fValues[4], (byte)this.fValues[5], 0, 0, 0, 0};
                Hashtable<String, String> ipAndBrd = IPV4Utils.getInstance().getOSIPAndBroadcastAdd();
                Enumeration<String> address = ipAndBrd.keys();
                while (address.hasMoreElements()) {
                    String add = address.nextElement();
                    int value = IPV4Utils.getInstance().formatToInt(add);
                    buf[11] = (byte)(value >> 24 & 0xFF);
                    buf[12] = (byte)(value >> 16 & 0xFF);
                    buf[13] = (byte)(value >> 8 & 0xFF);
                    buf[14] = (byte)(value & 0xFF);
                    DatagramPacket dp = new DatagramPacket(buf, buf.length, InetAddress.getByName(ipAndBrd.get(add)), 10002);
                    this.fDatagramSocket.send(dp);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void actionPerformed_SingleBMButton() {
        this.ivjReadBtn.setEnabled(true);
    }

    public void actionPerformed_LANButton() {
        this.ivjReadBtn.setEnabled(false);
    }

    protected void calendarToValues() {
        this.getDayField().setValue(this.fCalendar.get(5));
        this.getMonthField().setValue(this.fCalendar.get(2) + 1);
        this.getYearField().setValue(this.fCalendar.get(1));
        this.getHourField().setValue(this.fCalendar.get(11));
        this.getMinuteField().setValue(this.fCalendar.get(12));
    }

    private JButton getActualTimeBtn() {
        if (this.ivjActualTimeBtn == null) {
            try {
                this.ivjActualTimeBtn = new JButton();
                this.ivjActualTimeBtn.setName("ActualTimeBtn");
                this.ivjActualTimeBtn.setText("Akt. Zeit");
                this.ivjActualTimeBtn.setMaximumSize(new Dimension(81, 25));
                this.ivjActualTimeBtn.setActionCommand("Akt. Zeit");
                this.ivjActualTimeBtn.setBounds(250, 270, 107, 25);
                this.ivjActualTimeBtn.setMinimumSize(new Dimension(81, 25));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjActualTimeBtn;
    }

    private JButton getCalendarBtn() {
        if (this.ivjCalendarBtn == null) {
            try {
                this.ivjCalendarBtn = new JButton();
                this.ivjCalendarBtn.setName("CalendarBtn");
                this.ivjCalendarBtn.setHorizontalTextPosition(0);
                this.ivjCalendarBtn.setMargin(new Insets(2, 2, 2, 2));
                this.ivjCalendarBtn.setMinimumSize(new Dimension(27, 27));
                this.ivjCalendarBtn.setBounds(260, 38, 25, 24);
                this.ivjCalendarBtn.setText("Calendar");
                this.ivjCalendarBtn.setMaximumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCalendarBtn;
    }

    private JRadioButton getSingleBMRadioBtn() {
        if (this.fSingleBMButton == null) {
            this.fSingleBMButton = new JRadioButton(Language.getString("dialog.setClock.singleBM", "Single BM"));
            this.fSingleBMButton.addActionListener(this);
        }
        return this.fSingleBMButton;
    }

    private JRadioButton getLANRadioBtn() {
        if (this.fLANButton == null) {
            this.fLANButton = new JRadioButton(Language.getString("dialog.setClock.LAN", "LAN"));
            this.fLANButton.addActionListener(this);
        }
        return this.fLANButton;
    }

    private BorderJPanel getDatePanelBorder() {
        if (this.ivjDatePanelBorder == null) {
            try {
                this.ivjDatePanelBorder = new BorderJPanel();
                this.ivjDatePanelBorder.setName("DatePanelBorder");
                this.ivjDatePanelBorder.setBounds(17, 12, 335, 74);
                this.getDatePanelBorder().add((Component)this.getDayField(), this.getDayField().getName());
                this.getDatePanelBorder().add((Component)this.getMonthField(), this.getMonthField().getName());
                this.getDatePanelBorder().add((Component)this.getDayLabel(), this.getDayLabel().getName());
                this.getDatePanelBorder().add((Component)this.getMonthLabel(), this.getMonthLabel().getName());
                this.getDatePanelBorder().add((Component)this.getYearLabel(), this.getYearLabel().getName());
                this.getDatePanelBorder().add((Component)this.getYearField(), this.getYearField().getName());
                this.getDatePanelBorder().add((Component)this.getCalendarBtn(), this.getCalendarBtn().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDatePanelBorder;
    }

    private EditableNumericSpinner getDayField() {
        if (this.ivjDayField == null) {
            try {
                this.ivjDayField = new EditableNumericSpinner();
                this.ivjDayField.setName("DayField");
                this.ivjDayField.setFirstDelay(400);
                this.ivjDayField.setValue(12);
                this.ivjDayField.setMax(31);
                this.ivjDayField.setMin(1);
                this.ivjDayField.setPeriodicDelay(50);
                this.ivjDayField.setBounds(23, 38, 58, 24);
                this.ivjDayField.setMinimumSize(new Dimension(21, 22));
                this.ivjDayField.setIncrement(1);
                this.ivjDayField.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
                this.ivjDayField.setSliderActive(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDayField;
    }

    private JLabel getDayLabel() {
        if (this.ivjDayLabel == null) {
            try {
                this.ivjDayLabel = new JLabel();
                this.ivjDayLabel.setName("DayLabel");
                this.ivjDayLabel.setText("Tag");
                this.ivjDayLabel.setMaximumSize(new Dimension(21, 14));
                this.ivjDayLabel.setBounds(23, 18, 74, 15);
                this.ivjDayLabel.setMinimumSize(new Dimension(21, 14));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDayLabel;
    }

    private EditableNumericSpinner getHourField() {
        if (this.ivjHourField == null) {
            try {
                this.ivjHourField = new EditableNumericSpinner();
                this.ivjHourField.setName("HourField");
                this.ivjHourField.setFirstDelay(400);
                this.ivjHourField.setValue(13);
                this.ivjHourField.setMax(23);
                this.ivjHourField.setMin(0);
                this.ivjHourField.setPeriodicDelay(50);
                this.ivjHourField.setBounds(23, 38, 58, 24);
                this.ivjHourField.setMinimumSize(new Dimension(21, 22));
                this.ivjHourField.setIncrement(1);
                this.ivjHourField.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
                this.ivjHourField.setSliderActive(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjHourField;
    }

    private JLabel getHourLabel() {
        if (this.ivjHourLabel == null) {
            try {
                this.ivjHourLabel = new JLabel();
                this.ivjHourLabel.setName("HourLabel");
                this.ivjHourLabel.setText("Stunden");
                this.ivjHourLabel.setMaximumSize(new Dimension(47, 14));
                this.ivjHourLabel.setBounds(23, 18, 72, 15);
                this.ivjHourLabel.setMinimumSize(new Dimension(47, 14));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjHourLabel;
    }

    private EditableNumericSpinner getMinuteField() {
        if (this.ivjMinuteField == null) {
            try {
                this.ivjMinuteField = new EditableNumericSpinner();
                this.ivjMinuteField.setName("MinuteField");
                this.ivjMinuteField.setFirstDelay(400);
                this.ivjMinuteField.setValue(0);
                this.ivjMinuteField.setMax(59);
                this.ivjMinuteField.setMin(0);
                this.ivjMinuteField.setPeriodicDelay(50);
                this.ivjMinuteField.setBounds(99, 38, 58, 24);
                this.ivjMinuteField.setMinimumSize(new Dimension(21, 22));
                this.ivjMinuteField.setIncrement(1);
                this.ivjMinuteField.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
                this.ivjMinuteField.setSliderActive(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMinuteField;
    }

    private JLabel getMinuteLabel() {
        if (this.ivjMinuteLabel == null) {
            try {
                this.ivjMinuteLabel = new JLabel();
                this.ivjMinuteLabel.setName("MinuteLabel");
                this.ivjMinuteLabel.setText("Minuten");
                this.ivjMinuteLabel.setMaximumSize(new Dimension(45, 14));
                this.ivjMinuteLabel.setBounds(99, 18, 80, 15);
                this.ivjMinuteLabel.setMinimumSize(new Dimension(45, 14));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMinuteLabel;
    }

    private EditableNumericSpinner getMonthField() {
        if (this.ivjMonthField == null) {
            try {
                this.ivjMonthField = new EditableNumericSpinner();
                this.ivjMonthField.setName("MonthField");
                this.ivjMonthField.setFirstDelay(400);
                this.ivjMonthField.setValue(4);
                this.ivjMonthField.setMax(12);
                this.ivjMonthField.setMin(1);
                this.ivjMonthField.setPeriodicDelay(50);
                this.ivjMonthField.setBounds(104, 38, 58, 24);
                this.ivjMonthField.setMinimumSize(new Dimension(21, 22));
                this.ivjMonthField.setIncrement(1);
                this.ivjMonthField.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
                this.ivjMonthField.setSliderActive(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMonthField;
    }

    private JLabel getMonthLabel() {
        if (this.ivjMonthLabel == null) {
            try {
                this.ivjMonthLabel = new JLabel();
                this.ivjMonthLabel.setName("MonthLabel");
                this.ivjMonthLabel.setText("Monat");
                this.ivjMonthLabel.setMaximumSize(new Dimension(35, 14));
                this.ivjMonthLabel.setBounds(104, 18, 85, 15);
                this.ivjMonthLabel.setMinimumSize(new Dimension(35, 14));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMonthLabel;
    }

    public Dimension getPreferredSize() {
        return new Dimension(370, 224);
    }

    private JButton getReadBtn() {
        if (this.ivjReadBtn == null) {
            try {
                this.ivjReadBtn = new JButton();
                this.ivjReadBtn.setName("ReadBtn");
                this.ivjReadBtn.setText("Lesen");
                this.ivjReadBtn.setMaximumSize(new Dimension(69, 25));
                this.ivjReadBtn.setActionCommand("Lesen");
                this.ivjReadBtn.setBounds(12, 270, 107, 25);
                this.ivjReadBtn.setMinimumSize(new Dimension(69, 25));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjReadBtn;
    }

    private BorderJPanel getTimePanelBorder() {
        if (this.ivjTimePanelBorder == null) {
            try {
                this.ivjTimePanelBorder = new BorderJPanel();
                this.ivjTimePanelBorder.setName("TimePanelBorder");
                this.ivjTimePanelBorder.setBounds(17, 96, 335, 74);
                this.getTimePanelBorder().add((Component)this.getHourLabel(), this.getHourLabel().getName());
                this.getTimePanelBorder().add((Component)this.getMinuteLabel(), this.getMinuteLabel().getName());
                this.getTimePanelBorder().add((Component)this.getMinuteField(), this.getMinuteField().getName());
                this.getTimePanelBorder().add((Component)this.getHourField(), this.getHourField().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTimePanelBorder;
    }

    private BorderJPanel getSingleOrLANPanelBorder() {
        if (this.ivjSingleOrLanPanelBorder == null) {
            try {
                this.fSingleBMButton = this.getSingleBMRadioBtn();
                this.fSingleBMButton.setSelected(true);
                this.fLANButton = this.getLANRadioBtn();
                this.ivjSingleOrLanPanelBorder = new BorderJPanel(new GridLayout(2, 1));
                this.ivjSingleOrLanPanelBorder.setName("SingleOrLanPanelBorder");
                this.ivjSingleOrLanPanelBorder.setTitle(Language.getString("dialog.setClock.singleBMOrLANTitle", "Single BM or LAN"));
                this.ivjSingleOrLanPanelBorder.setBounds(17, 180, 335, 74);
                this.ivjSingleOrLanPanelBorder.add(this.fSingleBMButton);
                this.ivjSingleOrLanPanelBorder.add(this.fLANButton);
                ButtonGroup group = new ButtonGroup();
                group.add(this.fSingleBMButton);
                group.add(this.fLANButton);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSingleOrLanPanelBorder;
    }

    public String getTitle() {
        return Language.getString("dialog.setClock.title", "Set clock");
    }

    private JButton getWriteBtn() {
        if (this.ivjWriteBtn == null) {
            try {
                this.ivjWriteBtn = new JButton();
                this.ivjWriteBtn.setName("WriteBtn");
                this.ivjWriteBtn.setText("Schreiben");
                this.ivjWriteBtn.setMaximumSize(new Dimension(93, 25));
                this.ivjWriteBtn.setActionCommand("Schreiben");
                this.ivjWriteBtn.setBounds(131, 270, 107, 25);
                this.ivjWriteBtn.setMinimumSize(new Dimension(93, 25));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjWriteBtn;
    }

    private EditableNumericSpinner getYearField() {
        if (this.ivjYearField == null) {
            try {
                this.ivjYearField = new EditableNumericSpinner();
                this.ivjYearField.setName("YearField");
                this.ivjYearField.setFirstDelay(400);
                this.ivjYearField.setValue(2001);
                this.ivjYearField.setMax(2098);
                this.ivjYearField.setMin(2000);
                this.ivjYearField.setPeriodicDelay(50);
                this.ivjYearField.setBounds(190, 38, 58, 24);
                this.ivjYearField.setMinimumSize(new Dimension(21, 22));
                this.ivjYearField.setIncrement(1);
                this.ivjYearField.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
                this.ivjYearField.setSliderActive(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjYearField;
    }

    private JLabel getYearLabel() {
        if (this.ivjYearLabel == null) {
            try {
                this.ivjYearLabel = new JLabel();
                this.ivjYearLabel.setName("YearLabel");
                this.ivjYearLabel.setText("Jahr");
                this.ivjYearLabel.setMaximumSize(new Dimension(26, 14));
                this.ivjYearLabel.setBounds(190, 18, 80, 15);
                this.ivjYearLabel.setMinimumSize(new Dimension(26, 14));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjYearLabel;
    }

    private void handleException(Throwable exception) {
    }

    private void initialize() {
        try {
            this.setName("SetClockPanel");
            this.setLayout(null);
            this.add((Component)this.getDatePanelBorder(), this.getDatePanelBorder().getName());
            this.add((Component)this.getTimePanelBorder(), this.getTimePanelBorder().getName());
            this.add((Component)this.getSingleOrLANPanelBorder(), this.getSingleOrLANPanelBorder().getName());
            this.add((Component)this.getReadBtn(), this.getReadBtn().getName());
            this.add((Component)this.getWriteBtn(), this.getWriteBtn().getName());
            this.add((Component)this.getActualTimeBtn(), this.getActualTimeBtn().getName());
        }
        catch (Throwable ivjExc) {
            ivjExc.printStackTrace();
        }
        this.getWriteBtn().addActionListener(this);
        this.getActualTimeBtn().addActionListener(this);
        this.getReadBtn().addActionListener(this);
        this.getCalendarBtn().addActionListener(this);
    }

    protected void readDate() {
        DataTransfer dt = null;
        try {
            dt = DataTransfer.openConnection(true);
            if (!dt.isTransmissionPossible((JComponent)this.getParent())) {
                throw new ExceptionAlreadyHandledException();
            }
        }
        catch (ExceptionAlreadyHandledException eahe) {
            if (dt != null) {
                dt.closePort();
                dt = null;
            }
            return;
        }
        boolean tryAgain = true;
        boolean printLog = true;
        while (tryAgain) {
            try {
                dt.reset();
                dt.setBlockMode(false);
                this.fYearFrom2K = dt.getHardware() instanceof Logo6;
                dt.writeByte(this.getClockAddressGet(dt), 0);
                this.fValues = dt.readByteArray(this.getClockAddress(dt), 6);
                Log.printStartSequence("log.msg.readClockOK", "Read clock successful");
                tryAgain = false;
            }
            catch (TransmissionFailedException tfe) {
                if (printLog) {
                    Log.printStartSequence("log.err.readClockNotOK", "Read clock failed");
                    printLog = false;
                }
                tryAgain = LogoError.checkRepeatTransmission(tfe);
            }
        }
        dt.closePort();
        dt = null;
    }

    private final int getClockAddress(DataTransfer dt) {
        int ret = 64256;
        if (dt.getHardware() instanceof Logo6) {
            ret |= 0xFF0000;
        }
        return ret;
    }

    private final int getClockAddressGet(DataTransfer dt) {
        int ret = 17408;
        if (dt.getHardware() instanceof Logo6) {
            ret |= 0xFF0000;
        }
        return ret;
    }

    private final int getClockAddressSet(DataTransfer dt) {
        int ret = 17152;
        if (dt.getHardware() instanceof Logo6) {
            ret |= 0xFF0000;
        }
        return ret;
    }

    public void setLabels() {
        this.getActualTimeBtn().setText(Language.getString("dialog.setClock.actTimeBtn", "cur. Time"));
        this.getReadBtn().setText(Language.getString("dialog.setClock.readBtn", "Read"));
        this.getWriteBtn().setText(Language.getString("dialog.setClock.writeBtn", "Write"));
        this.getCalendarBtn().setIcon(Global.getIcon("DatePickerIcon.gif"));
        this.getDayLabel().setText(Language.getString("dialog.setClock.day", "Day"));
        this.getMonthLabel().setText(Language.getString("dialog.setClock.month", "Month"));
        this.getYearLabel().setText(Language.getString("dialog.setClock.year", "Year"));
        this.getMinuteLabel().setText(Language.getString("dialog.setClock.minute", "Minute"));
        this.getHourLabel().setText(Language.getString("dialog.setClock.hour", "Hour"));
        this.getTimePanelBorder().setTitle(Language.getString("dialog.setClock.time", "Time"));
        this.getDatePanelBorder().setTitle(Language.getString("dialog.setClock.date", "Date"));
    }

    private void showCalendarDlg() {
        DateChooserPanel dcp = new DateChooserPanel(2000, 2098);
        try {
            dcp.setYear(this.getYearField().getValue());
            dcp.setMonth(this.getMonthField().getValue());
            dcp.setDay(this.getDayField().getValue());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("SetClockPanel.showCalendarDlg() call in error.");
        }
        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.getDayLabel());
        SplittedDlg dialog = SplittedDlg.create(frame, dcp, 3);
        final JButton okButton = dialog.getControlPanel().getControlButton(1);
        dcp.addCalendarListener(new CalendarListener(){

            public void invalidDate(DateChooserPanel dcp) {
                okButton.setEnabled(false);
            }

            public void validDate(DateChooserPanel dcp) {
                okButton.setEnabled(true);
            }
        });
        dialog.show();
        if (dialog.getControlPanel().getResult() == 1) {
            this.getDayField().setValue(dcp.getDay());
            this.getMonthField().setValue(dcp.getMonth());
            this.getYearField().setValue(dcp.getYear());
        }
    }

    protected void writeDate() {
        DataTransfer dt = null;
        try {
            dt = DataTransfer.openConnection(true);
            if (!dt.isTransmissionPossible((JComponent)this.getParent())) {
                throw new ExceptionAlreadyHandledException();
            }
        }
        catch (ExceptionAlreadyHandledException eahe) {
            if (dt != null) {
                dt.closePort();
                dt = null;
            }
            return;
        }
        boolean tryAgain = true;
        boolean printLog = true;
        while (tryAgain) {
            try {
                dt.reset();
                dt.setBlockMode(false);
                dt.writeByteArray(this.getClockAddress(dt), this.fValues);
                dt.writeByte(this.getClockAddressSet(dt), 0);
                Log.printStartSequence("log.msg.writeClockOK", "Write clock sucessfull");
                tryAgain = false;
            }
            catch (TransmissionFailedException tfe) {
                if (printLog) {
                    Log.printStartSequence("log.err.writeClockNotOK", "Write clock failed");
                    printLog = false;
                }
                tryAgain = LogoError.checkRepeatTransmission(tfe);
            }
        }
        dt.closePort();
        dt = null;
    }

    class ReadTelegramThread
    extends Thread {
        private long startTime;

        ReadTelegramThread() {
        }

        public void refreshStartTime() {
            this.startTime = System.currentTimeMillis();
        }

        public void run() {
            byte[] buf = new byte[1024];
            DatagramPacket dp = new DatagramPacket(buf, 1024);
            this.startTime = System.currentTimeMillis();
            while (true) {
                try {
                    while (System.currentTimeMillis() < this.startTime + 5000L) {
                        SetClockPanel.this.fDatagramSocket.receive(dp);
                        byte[] data = dp.getData();
                        byte[] ipAddr = dp.getAddress().getAddress();
                        if (InetAddress.getLocalHost().getAddress() == ipAddr || data[0] != 6) continue;
                        Log.println(String.valueOf(ipAddr[0] & 0xFF) + "." + String.valueOf(ipAddr[1] & 0xFF) + "." + String.valueOf(ipAddr[2] & 0xFF) + "." + String.valueOf(ipAddr[3] & 0xFF) + ":" + " time synchronized successfully.\n");
                    }
                }
                catch (SocketTimeoutException e) {
                    continue;
                }
                catch (Exception e) {
                }
                break;
            }
        }
    }
}

